<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

header('Content-Type: application/json');

try {
    if ($_POST) {

        // Ödeme al
        if (isset($_POST['borcID']) && isset($_POST['odeme'])) {
            $borcID = (int)$_POST['borcID'];
            $borc = db::getId('tb_borc', $borcID);
            if (!$borc) throw new Exception('Borç bulunamadı');

            db::update('tb_borc', $borcID, [
                'durum' => 'ÖDENDİ',
                'gercek_odeme_tarihi' => date('Y-m-d')
            ]);
            // Kasa kaydı ekle
            db::insert('tb_kasa', [
                'tarih' => date('Y-m-d'),
                'kategori' => $borc->kategori,
                'odemeID' => $borcID,
                'tip' => 'GİRİŞ',
                'tutar' => $borc->tutar,
                'aciklama' => "Daire {$borc->daireID} ödemesi"
            ]);
            echo json_encode(['success' => true]);
            exit;
        }

        // Ödeme iptal
        if (isset($_POST['odemeID']) && isset($_POST['iptal'])) {
            $borcID = (int)$_POST['odemeID'];
            $borc = db::getId('tb_borc', $borcID);
            if (!$borc) throw new Exception('Borç bulunamadı');

            db::update('tb_borc', $borcID, [
                'durum' => 'BORÇ',
                'gercek_odeme_tarihi' => null
            ]);
            // Kasa kaydını sil
            // db::delete('tb_kasa', ['odemeID' => $borcID]);
            db::delete('tb_kasa', 0, 'WHERE odemeID = ?', array($borcID));
            echo json_encode(['success' => true]);
            exit;
        }
    }

    throw new Exception('Geçersiz işlem');
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
