<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';
require_once ROOT . '_libs/vendor/autoload.php'; // mPDF autoload

use Mpdf\Mpdf;

if (!isset($_GET['borcID'])) {
    die("Geçersiz borç ID");
}

$borcID = (int)$_GET['borcID'];

// Borç bilgilerini al
$borc = db::execOne("
    SELECT 
        b.ID AS borcID,
        d.daire_no,
        d.malik_adi,
        b.tutar,
        b.durum,
        b.odeme_tarihi,
        b.gercek_odeme_tarihi,
        b.kategori
    FROM tb_borc b
    INNER JOIN tb_daire d ON d.ID = b.daireID
    WHERE b.ID = ?
", [$borcID]);

if (!$borc) die("Borç bulunamadı");

// PDF oluştur
$mpdf = new Mpdf();
$mpdf->SetTitle("Ödeme Fişi - Borç #{$borc->borcID}");

$html = '
<h2 style="text-align:center">Ödeme Fişi</h2>
<hr>
<table style="width:100%;font-size:14px;">
<tr><td><strong>Daire No:</strong></td><td>'.$borc->daire_no.'</td></tr>
<tr><td><strong>Malik:</strong></td><td>'.$borc->malik_adi.'</td></tr>
<tr><td><strong>Kategori:</strong></td><td>'.$borc->kategori.'</td></tr>
<tr><td><strong>Tutar:</strong></td><td>'.number_format($borc->tutar,2,',','.').' ₺</td></tr>
<tr><td><strong>Planlanan Tarih:</strong></td><td>'.$borc->odeme_tarihi.'</td></tr>
<tr><td><strong>Gerçek Ödeme Tarihi:</strong></td><td>'.($borc->gercek_odeme_tarihi ?: '-').'</td></tr>
<tr><td><strong>Durum:</strong></td><td>'.$borc->durum.'</td></tr>
</table>
<hr>
<p style="text-align:center;font-size:12px;">Bu fiş sistem tarafından otomatik oluşturulmuştur.</p>
';

$mpdf->
