<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

// Tüm ödemeleri tb_borc üzerinden çek (aidat, demirbaş, vb tüm borçlar)
$odemeler = db::execAll("
    SELECT 
        b.ID AS borcID,
        d.daire_no,
        d.malik_adi,
        b.kategori,
        b.tutar,
        b.durum,
        b.odeme_tarihi,
        b.gercek_odeme_tarihi
    FROM tb_borc b
    INNER JOIN tb_daire d ON d.ID = b.daireID
    WHERE b.durum = 'Odendi'   -- sadece ödenmişleri getir
    ORDER BY b.gercek_odeme_tarihi DESC, b.odeme_tarihi DESC
");

require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';
?>

<div class="flex-fill p-4">
    <h4>Ödemeler</h4>

    <table class="table table-bordered table-hover align-middle mt-3">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Daire</th>
                <th>Malik</th>
                <th>Kategori</th>
                <th>Tutar</th>
                <th>Durum</th>
                <th>Planlanan Tarih</th>
                <th>Gerçek Ödeme</th>
                <th>Fiş</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($odemeler as $o): ?>
                <tr class="<?= $o->durum === 'BORÇ' ? 'table-danger' : 'table-success' ?>">
                    <td><?= $o->borcID ?></td>
                    <td><?= htmlspecialchars($o->daire_no) ?></td>
                    <td><?= htmlspecialchars($o->malik_adi) ?></td>
                    <td><?= htmlspecialchars($o->kategori) ?></td>
                    <td><?= number_format($o->tutar, 2, ',', '.') ?> ₺</td>
                    <td><?= $o->durum ?></td>
                    <td><?= $o->odeme_tarihi ?></td>
                    <td><?= $o->gercek_odeme_tarihi ?: '-' ?></td>
                    <td>
                        <?php if ($o->durum !== 'BORÇ'): ?>
                            <a href="../odeme/odeme_fis.php?borcID=<?= $o->borcID ?>"
                                target="_blank"
                                class="btn btn-sm btn-outline-secondary">
                                🧾 Fiş
                            </a>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>