<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

header('Content-Type: application/json');

$res = ['success' => false];

try {
    if ($_POST) {
        $borcID = isset($_POST['borcID']) ? (int)$_POST['borcID'] : 0;
        $tutar  = isset($_POST['tutar']) ? (float)$_POST['tutar'] : null;

        if (!$borcID || $tutar === null) {
            throw new Exception('Geçersiz veri.');
        }

        $borc = db::getId('tb_borc', $borcID);
        if (!$borc) {
            throw new Exception('Borç bulunamadı.');
        }

        db::update('tb_borc', $borcID, [
            'tutar' => $tutar
        ]);

        $res['success'] = true;
    } else {
        throw new Exception('POST verisi yok.');
    }
} catch (Exception $e) {
    $res['error'] = $e->getMessage();
}

echo json_encode($res);
