<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

$daireler = db::execAll("SELECT ID, daire_no, malik_adi FROM tb_daire WHERE aktif=1 ORDER BY daire_no ASC");

if ($_POST) {
    db::insert("tb_odeme", [
        'daireID' => $_POST['daireID'],
        'aidatID' => $_POST['aidatID'] ?: null,
        'tutar' => $_POST['tutar'],
        'kategori' => $_POST['kategori'] ?: null,
        'odeme_tarihi' => $_POST['odeme_tarihi'],
        'durum' => $_POST['durum']
    ]);
    header("Location: index.php");
    exit;
}

require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';
?>

<div class="flex-fill p-4">
    <h4>Yeni Ödeme Ekle</h4>

    <form method="post" style="max-width:480px">
        <div class="mb-2">
            <label class="form-label">Daire</label>
            <select name="daireID" class="form-select" required>
                <option value="">Seçiniz</option>
                <?php foreach ($daireler as $d): ?>
                    <option value="<?= $d->ID ?>"><?= $d->daire_no ?> - <?= $d->malik_adi ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-2">
            <label class="form-label">Kategori (opsiyonel)</label>
            <input type="text" name="kategori" class="form-control" placeholder="Örn: Aidat, Demirbaş">
        </div>

        <div class="mb-2">
            <label class="form-label">Tutar</label>
            <input type="number" step="0.01" name="tutar" class="form-control" required>
        </div>

        <div class="mb-2">
            <label class="form-label">Ödeme Tarihi</label>
            <input type="date" name="odeme_tarihi" class="form-control" required>
        </div>

        <div class="mb-2">
            <label class="form-label">Durum</label>
            <select name="durum" class="form-select" required>
                <option value="Odenmis">Ödenmiş</option>
                <option value="Odenmedi">Ödenmedi</option>
            </select>
        </div>

        <button class="btn btn-primary">Kaydet</button>
        <a href="index.php" class="btn btn-secondary">İptal</a>
    </form>
</div>