<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

$odeme = db::getId("tb_odeme", $_GET['id']);
$daireler = db::execAll("SELECT ID, daire_no, malik_adi FROM tb_daire WHERE aktif=1 ORDER BY daire_no ASC");

if ($_POST) {
    db::update("tb_odeme", $_GET['id'], [
        'daireID'       => $_POST['daireID'],
        'aidatID'       => $_POST['aidatID'] ?: null,
        'tutar'         => $_POST['tutar'],
        'kategori'      => $_POST['kategori'] ?: null,
        'odeme_tarihi'  => $_POST['odeme_tarihi'],
        'durum'         => $_POST['durum']
    ]);
    header("Location: index.php");
    exit;
}

require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';
?>

<div class="flex-fill p-4">
    <h4>Ödeme Düzenle</h4>

    <form method="post" style="max-width:480px">
        <div class="mb-2">
            <label class="form-label">Daire</label>
            <select name="daireID" class="form-select" required>
                <?php foreach ($daireler as $d): ?>
                    <option value="<?= $d->ID ?>" <?= $d->ID == $odeme->daireID ? 'selected' : '' ?>>
                        <?= $d->daire_no ?> - <?= $d->malik_adi ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-2">
            <label class="form-label">Kategori (opsiyonel)</label>
            <input type="text" name="kategori" class="form-control" value="<?= $odeme->kategori ?>">
        </div>

        <div class="mb-2">
            <label class="form-label">Tutar</label>
            <input type="number" step="0.01" name="tutar" class="form-control" value="<?= $odeme->tutar ?>" required>
        </div>

        <div class="mb-2">
            <label class="form-label">Ödeme Tarihi</label>
            <input type="date" name="odeme_tarihi" class="form-control" value="<?= $odeme->odeme_tarihi ?>" required>
        </div>

        <div class="mb-2">
            <label class="form-label">Durum</label>
            <select name="durum" class="form-select" required>
                <option value="Odenmis" <?= $odeme->durum == 'Odenmis' ? 'selected' : '' ?>>Ödenmiş</option>
                <option value="Odenmedi" <?= $odeme->durum == 'Odenmedi' ? 'selected' : '' ?>>Ödenmedi</option>
            </select>
        </div>

        <button class="btn btn-primary">Güncelle</button>
        <a href="index.php" class="btn btn-secondary">İptal</a>
    </form>
</div>