<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

$giderler = db::execAll("
    SELECT g.*, a.apartman_adi 
    FROM tb_gider g
    LEFT JOIN tb_apartman a ON a.ID = g.apartmanID
    ORDER BY g.tarih DESC
");

require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';
?>

<div class="flex-fill p-4">
    <div class="d-flex justify-content-between mb-3">
        <h4>Giderler</h4>
        <a href="ekle.php" class="btn btn-primary btn-sm">+ Yeni Gider</a>
    </div>

    <table class="table table-bordered table-hover align-middle">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Apartman</th>
                <th>Tarih</th>
                <th>Tür</th>
                <th>Tutar</th>
                <th>Açıklama</th>
                <th>İşlem</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($giderler as $g): ?>
                <tr>
                    <td><?= $g->ID ?></td>
                    <td><?= $g->apartman_adi ?></td>
                    <td><?= $g->tarih ?></td>
                    <td><?= $g->kategori  ?></td>
                    <td><?= number_format($g->tutar, 2) ?> ₺</td>
                    <td><?= $g->aciklama ?></td>
                    <td>
                        <a href="duzenle.php?id=<?= $g->ID ?>" class="btn btn-sm btn-warning">Düzenle</a>
                        <a href="sil.php?id=<?= $g->ID ?>" onclick="return confirm('Silinsin mi?')" class="btn btn-sm btn-danger">Sil</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php require_once ROOT . 'layout/footer.php'; ?>