<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

$demirbasID = (int)$_POST['demirbasID'];
$ayYil      = $_POST['ayYil'] ?? date('Y-m');
$taksitSayisi = (int)($_POST['taksit_sayisi'] ?? 1);

list($yil, $ay) = explode('-', $ayYil);

$demirbas = db::getId('td_demirbas', $demirbasID);
if (!$demirbas) {
    die("Ürün bulunamadı.");
}

// Gelir türü Demirbaş
$gelirTur = db::execOne("SELECT ID FROM tb_gelir_tur WHERE tur_adi='Demirbaş'");
$gelirTurID = $gelirTur->ID ?? 0;

// Tüm aktif daireler
$daireler = db::execAll("SELECT ID FROM tb_daire WHERE aktif=1");

foreach ($daireler as $d) {
    $taksitTutar = round($demirbas->tutar / $taksitSayisi, 2);
    for ($i = 1; $i <= $taksitSayisi; $i++) {
        db::insert('tb_borc', [
            'daireID' => $d->ID,
            'gelirTurID' => $gelirTurID,
            'kategori' => 'Demirbaş',
            'tutar' => $taksitTutar,
            'taksit_no' => $i,
            'taksit_sayisi' => $taksitSayisi,
            'odeme_tarihi' => date('Y-m-d'),
            'durum' => 'BORÇ'
        ]);
    }
}

echo count($daireler) . " daire için Demirbaş borçları üretildi.";
