<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

header('Content-Type: application/json');
$res = ['success' => false];

if ($_POST) {
    $borcID = (int)$_POST['borcID'];

    // Ödeme al
    if (isset($_POST['odeme'])) {
        $tutar = (float)$_POST['tutar'];
        try {
            db::update('tb_borc', $borcID, [
                'tutar' => $tutar,
                'gercek_odeme_tarihi' => date('Y-m-d'),
                'durum' => 'ÖDENDİ'
            ]);

            // Kasa kaydı ekle
            db::insert('tb_kasa', [
                'tarih' => date('Y-m-d'),
                'kategori' => $kategori,
                'odemeID' => $borcID,
                'tutar' => $tutar,
                'aciklama' => "Daire {$daireID} ödemesi"
            ]);

            $res['success'] = true;
        } catch (Exception $e) {
            $res['error'] = $e->getMessage();
        }
    }

    // Ödeme iptal
    if (isset($_POST['iptal'])) {
        try {
            db::update('tb_borc', $borcID, [
                'gercek_odeme_tarihi' => NULL,
                'durum' => 'BORÇ'
            ]);

            // Kasa kaydını sil
            // db::delete('tb_kasa', ['odemeID' => $borcID]);
            db::delete('tb_kasa', 0, 'WHERE odemeID = ?', array($borcID));
            $res['success'] = true;
        } catch (Exception $e) {
            $res['error'] = $e->getMessage();
        }
    }
}

echo json_encode($res);
