<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';
require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';

// Tüm Demirbaş ürünleri
$demirbaslar = db::execAll("
    SELECT d.*, k.kategori_adi 
    FROM td_demirbas d
    LEFT JOIN td_demirbas_kategori k ON d.kategoriID = k.ID
    ORDER BY d.demirbas_adi ASC
");

// Tüm Demirbaş borçları
$gelirTur = db::execOne("SELECT ID FROM tb_gelir_tur WHERE tur_adi='Demirbaş'");
$gelirTurID = $gelirTur->ID ?? 0;

$borclar = db::execAll("
    SELECT b.*, d.daire_no, d.malik_adi
    FROM tb_borc b
    LEFT JOIN tb_daire d ON b.daireID=d.ID
    WHERE b.kategori='Demirbaş' AND b.gelirTurID=?
    ORDER BY b.odeme_tarihi DESC
", [$gelirTurID]);
?>

<div class="flex-fill p-4">
    <div class="d-flex justify-content-between mb-3">
        <h4>Demirbaş Borçları</h4>
        <div>
            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#topluUretModal">
                + Toplu Üret
            </button>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#yeniUrunModal">
                + Yeni Ürün
            </button>
            <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#geriAlModal">
                ↩️ Geri Al
            </button>
        </div>
    </div>

    <table class="table table-bordered table-hover align-middle">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Daire</th>
                <th>Malik</th>
                <th>Tutar</th>
                <th>Taksit</th>
                <th>Durum</th>
                <th>Ödeme Tarihi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($borclar as $b): ?>
                <tr class="<?= $b->durum === 'BORÇ' ? 'table-danger' : 'table-success' ?>">
                    <td><?= $b->ID ?></td>
                    <td><?= $b->daire_no ?></td>
                    <td><?= $b->malik_adi ?></td>
                    <td><?= number_format($b->tutar, 2) ?> ₺</td>
                    <td><?= $b->taksit_no ?> / <?= $b->taksit_sayisi ?></td>
                    <td><?= $b->durum ?></td>
                    <td><?= $b->gercek_odeme_tarihi ?: '-' ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Toplu Üret Modal -->
<div class="modal fade" id="topluUretModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="uret.php">
                <div class="modal-header">
                    <h5 class="modal-title">Demirbaş Toplu Üret</h5>
                </div>
                <div class="modal-body">
                    <select name="demirbasID" class="form-select mb-2" required>
                        <option value="">Ürün Seç</option>
                        <?php foreach ($demirbaslar as $d): ?>
                            <option value="<?= $d->ID ?>">
                                [<?= $d->kategori_adi ?? 'Belirtilmemiş' ?>] <?= $d->demirbas_adi ?> (<?= number_format($d->tutar, 2) ?> ₺)
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <input type="month" name="ayYil" class="form-control mb-2" value="<?= date('Y-m') ?>" required>
                    <input type="number" name="taksit_sayisi" class="form-control" value="1" min="1" required>
                    <div class="alert alert-warning mt-2">
                        Bu işlem tüm aktif daireler için Demirbaş borcu oluşturur.
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button class="btn btn-success">Üret</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Yeni Ürün Modal -->
<div class="modal fade" id="yeniUrunModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="yeni_urun_ekle.php">
                <div class="modal-header">
                    <h5 class="modal-title">Yeni Demirbaş Ürünü Ekle</h5>
                </div>
                <div class="modal-body">
                    <input type="text" name="demirbas_adi" class="form-control mb-2" placeholder="Ürün Adı" required>
                    <input type="number" step="0.01" name="tutar" class="form-control mb-2" placeholder="Tutar" required>
                    <input type="text" name="kategori_adi" class="form-control" placeholder="Kategori" required>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button class="btn btn-success">Ekle</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Geri Alma Modal -->
<div class="modal fade" id="geriAlModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="geri_al.php">
                <div class="modal-header">
                    <h5 class="modal-title">Demirbaş Üretimi Geri Al</h5>
                </div>
                <div class="modal-body">
                    <p>Dikkat! Sadece ödenmemiş Demirbaş borçları silinecektir.</p>
                    <p>Bu işlem geri alınamaz.</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button class="btn btn-danger">Geri Al</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="<?= BASE_URL ?>assets/js/jquery.min.js"></script>
<script src="<?= BASE_URL ?>assets/bootstrap/js/bootstrap.bundle.min.js"></script>
<?php require_once ROOT . 'layout/footer.php'; ?>