<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

// Ayarlanacak değerler
$demirbasTutar = 2400; // her dairenin toplam Demirbaş borcu
$taksitSayisi = 3;     // kaç taksit olacak
$baslangicTarihi = date('Y-m-d'); // ilk taksit tarihi

// Tüm aktif daireler
$daireler = db::execAll("SELECT ID, daire_no FROM tb_daire WHERE aktif=1");

foreach ($daireler as $daire) {
    $taksitTutari = round($demirbasTutar / $taksitSayisi, 2);

    for ($i = 1; $i <= $taksitSayisi; $i++) {
        // Her taksit için ödeme tarihi ay bazlı
        $tarih = date('Y-m-d', strtotime("+" . ($i - 1) . " months", strtotime($baslangicTarihi)));

        db::insert("tb_borc", [
            'daireID' => $daire->ID,
            'kategori' => 'Demirbaş',
            'tutar' => $taksitTutari,
            'taksit_no' => $i,
            'taksit_sayisi' => $taksitSayisi,
            'odeme_tarihi' => $tarih,
            'durum' => 'BORÇ'
        ]);
    }

    echo "Daire {$daire->daire_no} için Demirbaş borçları eklendi.<br>";
}

echo "<br>✅ Tüm borçlar eklendi!";
