<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

// Ay ve Yıl
$ay  = $_POST['ay'] ?? date('m');
$yil = $_POST['yil'] ?? date('Y');
$tutar = $_POST['tutar'] ?? 500; // Örn: her dairenin aylık aidatı

// Tüm aktif daireler
$daireler = db::execAll("SELECT ID, daire_no FROM tb_daire WHERE aktif=1");

foreach ($daireler as $daire) {
    // Aynı ay/yıl için daha önce eklenmiş mi kontrol et
    $kontrol = db::execOne("
        SELECT ID FROM tb_borc 
        WHERE daireID=? AND kategori='Aidat' AND YEAR(odeme_tarihi)=? AND MONTH(odeme_tarihi)=?
    ", [$daire->ID, $yil, $ay]);

    if (!$kontrol) {
        db::insert("tb_borc", [
            'daireID' => $daire->ID,
            'kategori' => 'Aidat',
            'tutar' => $tutar,
            'taksit_no' => 1,
            'taksit_sayisi' => 1,
            'odeme_tarihi' => "$yil-$ay-01",
            'durum' => 'BORÇ'
        ]);
    }
}

echo "✅ $ay/$yil aidatları tüm daireler için eklendi!";
