<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';
$hata = '';

// Apartman listesini çek
$apartmanlar = db::execAll("SELECT ID, apartman_adi, daire_sayisi, kayitli_daire FROM tb_apartman ORDER BY apartman_adi");

if ($_POST) {
    $apartman = db::getId("tb_apartman", $_POST['apartmanID']);

    if ($apartman->kayitli_daire >= $apartman->daire_sayisi) {
        $hata = "Bu apartman maksimum daire sayısına ulaştı!";
    } else {
        db::insert("tb_daire", [
            'apartmanID' => $_POST['apartmanID'],
            'daire_no'   => $_POST['daire_no'],
            'kat'        => $_POST['kat'],
            'malik_adi'  => $_POST['malik_adi'],
            'telefon'    => $_POST['telefon'],
            'aktif'      => 1
        ]);

        // Apartmandaki kayitli daire sayısını artır
        db::execOne("UPDATE tb_apartman SET kayitli_daire = kayitli_daire + 1 WHERE ID = ?", [$apartman->ID]);

        header("Location: index.php");
        exit;
    }
}

require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';
?>

<div class="flex-fill p-4">
    <h3 class="mb-4">➕ Daire Ekle</h3>
    <div class="card shadow-sm border p-3" style="max-width:700px;">

        <?php if ($hata): ?>
            <div class="alert alert-danger"><?= $hata ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="row g-3 mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-bold">Apartman</label>
                    <select name="apartmanID" class="form-select" required>
                        <option value="">Seçiniz</option>
                        <?php foreach ($apartmanlar as $a): ?>
                            <option value="<?= $a->ID ?>"><?= $a->apartman_adi ?> (<?= $a->kayitli_daire ?>/<?= $a->daire_sayisi ?>)</option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-bold">Daire No</label>
                    <input type="text" name="daire_no" class="form-control" placeholder="Örn: 5A" required>
                </div>
            </div>

            <div class="row g-3 mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-bold">Kat</label>
                    <input type="number" name="kat" class="form-control" placeholder="Örn: 3">
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-bold">Malik Adı</label>
                    <input type="text" name="malik_adi" class="form-control" placeholder="Örn: Ahmet Yılmaz">
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Telefon</label>
                <input type="text" name="telefon" class="form-control" placeholder="0555 555 55 55">
            </div>

            <div class="d-flex gap-2 mt-3">
                <a href="index.php" class="btn btn-secondary">İptal</a>
                <button class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
</div>

<?php require_once ROOT . 'layout/footer.php'; ?>