<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

$apartmanlar = db::execAll("SELECT * FROM tb_apartman ORDER BY ID ASC");

require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';
?>

<div class="flex-fill p-4">
    <div class="d-flex justify-content-between mb-3">
        <h4>Apartmanlar</h4>
        <a href="ekle.php" class="btn btn-primary btn-sm">+ Yeni Apartman</a>
    </div>

    <table id="daireTable" class="table table-bordered table-hover align-middle">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Adı</th>
                <th>Yönetici</th>
                <th>Daire Sayısı</th>
                <th>Kayitlı Daire</th>
                <th>İşlem</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($apartmanlar as $a): ?>
                <tr>
                    <td><?= $a->ID ?></td>
                    <td><?= $a->apartman_adi ?></td>
                    <td><?= $a->yonetici_adi ?></td>
                    <td><?= $a->daire_sayisi ?></td>
                    <td><?= $a->kayitli_daire ?></td>
                    <td>
                        <a href="duzenle.php?id=<?= $a->ID ?>" class="btn btn-sm btn-warning">Düzenle</a>
                        <?php if ($a->kayitli_daire == 0): ?>
                            <a href="sil.php?id=<?= $a->ID ?>" onclick="return confirm('Silinsin mi?')" class="btn btn-sm btn-danger">Sil</a>
                        <?php else: ?>
                            <button class="btn btn-sm btn-secondary" disabled>Sil</button>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
<script src="<?= BASE_URL ?>assets/js/jquery.min.js"></script>
<link rel="stylesheet" href="<?= BASE_URL ?>assets/datatables/datatables.min.css" />
<script src="<?= BASE_URL ?>assets/datatables/datatables.min.js"></script>

<script>
    $(document).ready(function() {
        $('#daireTable').DataTable({
            "paging": false,
            "lengthChange": false,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/tr.json"
            }
        });
    });
</script>
<?php require_once ROOT . 'layout/footer.php'; ?>