<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';
$hata = '';

if ($_POST) {
    if ((int)$_POST['daire_sayisi'] < 1) {
        $hata = "Daire sayısı 1 veya daha fazla olmalıdır!";
    } else {
        db::insert("tb_apartman", [
            'apartman_adi' => $_POST['apartman_adi'],
            'adres'        => $_POST['adres'],
            'yonetici_adi' => $_POST['yonetici_adi'],
            'daire_sayisi' => $_POST['daire_sayisi'],
            'kayitli_daire' => 0
        ]);
        header("Location: index.php");
        exit;
    }
}

require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';
?>

<div class="flex-fill p-4">
    <h3 class="mb-4">🏢 Apartman Ekle</h3>
    <div class="card shadow-sm border p-3" style="max-width:700px;">

        <?php if ($hata): ?>
            <div class="alert alert-danger"><?= $hata ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="row g-3 mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-bold">Apartman Adı</label>
                    <input type="text" name="apartman_adi" class="form-control" placeholder="Örn: Mervan Sitesi" required>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-bold">Yönetici Adı</label>
                    <input type="text" name="yonetici_adi" class="form-control" placeholder="Örn: Ahmet Yılmaz">
                </div>
            </div>

            <div class="row g-3 mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-bold">Toplam Daire Sayısı</label>
                    <input type="number" name="daire_sayisi" class="form-control" placeholder="Örn: 12" required>
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label fw-bold">Adres</label>
                <textarea name="adres" class="form-control" rows="3" placeholder="Örn: Konya, Meram, ..."></textarea>
            </div>

            <div class="d-flex gap-2 mt-3">
                <a href="index.php" class="btn btn-secondary">İptal</a>
                <button class="btn btn-primary">Kaydet</button>
            </div>
        </form>
    </div>
</div>

<?php require_once ROOT . 'layout/footer.php'; ?>