
<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';
require_once ROOT . '/vendor/autoload.php';

use Mpdf\Mpdf;

$odeme = db::execOne("
SELECT o.*, d.daire_no, d.malik_adi, a.yil, a.ay
FROM tb_odeme o
JOIN tb_daire d ON d.ID = o.daireID
JOIN tb_aidat a ON a.ID = o.aidatID
WHERE o.ID = ?
", [$_GET['odemeID']]);

$mpdf = new Mpdf();

$html = "
<h3>Aidat Tahsilat Fişi</h3>
<hr>
<b>Daire:</b> {$odeme->daire_no}<br>
<b>Malik:</b> {$odeme->malik_adi}<br>
<b>Dönem:</b> {$odeme->ay}/{$odeme->yil}<br>
<b>Tutar:</b> " . number_format($odeme->tutar, 2, ',', '.') . " ₺<br>
<b>Ödeme Tarihi:</b> {$odeme->odeme_tarihi}
";

$mpdf->WriteHTML($html);
$mpdf->Output();
