<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

$borclar = db::execAll("
    SELECT 
        d.daire_no,
        d.malik_adi,
        COUNT(a.ID) adet,
        SUM(a.tutar) toplam
    FROM tb_aidat a
    INNER JOIN tb_daire d ON d.ID=a.daireID
    WHERE a.durum='Odenmedi'
    GROUP BY d.ID
");
?>

<table class="table table-bordered">
    <tr>
        <th>Daire</th>
        <th>Malik</th>
        <th>Borç Ay</th>
        <th>Toplam</th>
    </tr>
    <?php foreach ($borclar as $b): ?>
        <tr>
            <td><?= $b->daire_no ?></td>
            <td><?= $b->malik_adi ?></td>
            <td><?= $b->adet ?></td>
            <td><?= number_format($b->toplam, 2) ?> ₺</td>
        </tr>
    <?php endforeach; ?>
</table>