<?php
require_once '../../config.php';
require_once ROOT . 'app/db.php';

$aidatID = $_POST['aidatID'] ?? null;

if (!$aidatID) {
    echo json_encode(['success' => false, 'error' => 'AidatID yok']);
    exit;
}

$aidat = db::execOne("
    SELECT * FROM tb_aidat WHERE ID=?
", [$aidatID]);

if (!$aidat) {
    echo json_encode(['success' => false, 'error' => 'Aidat bulunamadı']);
    exit;
}

try {
    // 1️⃣ Ödeme ekle
    db::execOne("
        INSERT INTO tb_odeme (aidatID, daireID, tutar, odeme_tarihi)
        VALUES (?, ?, ?, CURDATE())
    ", [
        $aidat->ID,
        $aidat->daireID,
        $aidat->tutar
    ]);

    // 2️⃣ Aidat durumunu güncelle
    db::update('tb_aidat', $aidat->ID, [
        'durum' => 'Odendi'
    ]);

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
