<!-- ================================ -->
<!-- LOGIN.PHP -->
<!-- ================================ -->
<?php
session_start();
require_once 'app/db.php';


if ($_POST) {
    $user = db::execOne(
        "SELECT * FROM tb_user WHERE kullanici_adi=? AND aktif=1",
        [$_POST['username']]
    );


    if ($user && password_verify($_POST['password'], $user->sifre)) {
        $_SESSION['user'] = [
            'id' => $user->id,
            'ad' => $user->ad_soyad,
            'yetki' => $user->yetki
        ];
        header("Location: dashboard.php");
        exit;
    } else {
        $hata = "Kullanıcı adı veya şifre hatalı";
    }
}
// var_dump($_POST['password']);
// var_dump($user->sifre);
// var_dump(password_verify($_POST['password'], $user->sifre));
// exit;
?>
<!doctype html>
<html lang="tr">

<head>
    <meta charset="utf-8">
    <title>Yönetici Girişi</title>
    <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css">


</head>

<body class="bg-light">
    <div class="container d-flex justify-content-center align-items-center" style="height:100vh;">
        <div class="card shadow" style="width:360px;">
            <div class="card-body">
                <h4 class="text-center mb-3">Apartman Yönetimi</h4>
                <?php if (isset($hata)): ?>
                    <div class="alert alert-danger"><?= $hata ?></div>
                <?php endif; ?>
                <form method="post">
                    <input class="form-control mb-2" name="username" placeholder="Kullanıcı Adı" required>
                    <input type="password" class="form-control mb-3" name="password" placeholder="Şifre" required>
                    <button class="btn btn-primary w-100">Giriş Yap</button>
                </form>
            </div>
        </div>
    </div>
</body>

</html>