<?php
require_once 'config.php';
require_once ROOT . 'app/db.php';
require_once ROOT . 'layout/header.php';
require_once ROOT . 'layout/sidebar.php';

// -----------------------------
// Hızlı istatistikler
// -----------------------------
$daireSayisi = db::execOne("SELECT COUNT(*) AS total FROM tb_daire")->total;
$kasadakiPara = db::execOne("
    SELECT COALESCE(SUM(
        CASE 
            WHEN tip='GİRİŞ' THEN tutar
            WHEN tip='ÇIKIŞ' THEN -tutar
            ELSE 0
        END
    ), 0) AS toplam
    FROM tb_kasa
")->toplam;

$odenmemisBorc = db::execOne("SELECT COALESCE(SUM(tutar),0) AS toplam FROM tb_borc WHERE durum='BORÇ'")->toplam;
$demirbasSayisi = db::execOne("SELECT COUNT(*) AS total FROM td_demirbas")->total;

// -----------------------------
// Son ödemeler
// -----------------------------
$sonOdemeler = db::execAll("
    SELECT b.ID AS borcID, d.daire_no, d.malik_adi, b.kategori, b.tutar, b.gercek_odeme_tarihi
    FROM tb_borc b
    INNER JOIN tb_daire d ON d.ID = b.daireID
    WHERE b.durum='ÖDENDİ'
    ORDER BY b.gercek_odeme_tarihi DESC
    LIMIT 10
");

// -----------------------------
// Kasa hareketleri (son 20)
// -----------------------------
$kasaHareketleri = db::execAll("
    SELECT *
    FROM tb_kasa
    ORDER BY tarih DESC
    LIMIT 20
");
?>

<div class="flex-fill p-4">
    <h4>🏢 Yönetim Paneli Dashboard</h4>

    <div class="row mt-4 g-3">
        <!-- Daire Sayısı -->
        <div class="col-md-3">
            <div class="card text-white bg-primary">
                <div class="card-body">
                    <h5 class="card-title">Daireler</h5>
                    <p class="card-text display-6"><?= $daireSayisi ?></p>
                    <i class="bi bi-house-door-fill" style="font-size:2rem"></i>
                </div>
            </div>
        </div>

        <!-- Kasadaki Para -->
        <div class="col-md-3">
            <div class="card text-white bg-warning">
                <div class="card-body">
                    <h5 class="card-title">Kasa</h5>
                    <p class="card-text display-6"><?= number_format($kasadakiPara, 2, ',', '.') ?> ₺</p>
                    <i class="bi bi-cash-stack" style="font-size:2rem"></i>
                </div>
            </div>
        </div>

        <!-- Ödenmemiş Borç -->
        <div class="col-md-3">
            <div class="card text-white bg-danger">
                <div class="card-body">
                    <h5 class="card-title">Ödenmemiş Borç</h5>
                    <p class="card-text display-6"><?= number_format($odenmemisBorc, 2, ',', '.') ?> ₺</p>
                    <i class="bi bi-exclamation-triangle-fill" style="font-size:2rem"></i>
                </div>
            </div>
        </div>

        <!-- Demirbaş Sayısı -->
        <div class="col-md-3">
            <div class="card text-white bg-info">
                <div class="card-body">
                    <h5 class="card-title">Demirbaş</h5>
                    <p class="card-text display-6"><?= $demirbasSayisi ?></p>
                    <i class="bi bi-box-seam" style="font-size:2rem"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Son Ödemeler -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>💳 Son Ödeme Yapanlar</h5>
                    <table id="sonOdemeler" class="table table-bordered table-hover table-striped">
                        <thead>
                            <tr>
                                <th>Daire</th>
                                <th>Malik</th>
                                <th>Kategori</th>
                                <th>Tutar</th>
                                <th>Ödeme Tarihi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($sonOdemeler as $s): ?>
                                <tr>
                                    <td><?= htmlspecialchars($s->daire_no) ?></td>
                                    <td><?= htmlspecialchars($s->malik_adi) ?></td>
                                    <td><?= htmlspecialchars($s->kategori) ?></td>
                                    <td><?= number_format($s->tutar, 2, ',', '.') ?> ₺</td>
                                    <td><?= $s->gercek_odeme_tarihi ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Kasa Hareketleri -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>💰 Kasa Hareketleri</h5>
                    <table id="kasaHareketleri" class="table table-bordered table-hover table-striped">
                        <thead>
                            <tr>
                                <th>Tarih</th>
                                <th>Açıklama</th>
                                <th>Giriş</th>
                                <th>Çıkış</th>
                                <th>Bakiye</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $bakiye = 0;
                            foreach ($kasaHareketleri as $h):
                                $bakiye += $h->tip === 'GİRİŞ' ? $h->tutar : -$h->tutar;
                            ?>
                                <tr>
                                    <td><?= $h->tarih ?></td>
                                    <td><?= htmlspecialchars($h->aciklama) ?></td>
                                    <td><?= $h->tip === 'GİRİŞ' ? number_format($h->tutar, 2, ',', '.') : '-' ?> ₺</td>
                                    <td><?= $h->tip === 'ÇIKIŞ' ? number_format($h->tutar, 2, ',', '.') : '-' ?> ₺</td>
                                    <td><?= number_format($bakiye, 2, ',', '.') ?> ₺</td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>

<link rel="stylesheet" href="<?= BASE_URL ?>assets/datatables/datatables.min.css">
<script src="<?= BASE_URL ?>assets/js/jquery.min.js"></script>
<script src="<?= BASE_URL ?>assets/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="<?= BASE_URL ?>assets/datatables/datatables.min.js"></script>

<script>
    $(document).ready(function() {
        $('#sonOdemeler').DataTable({
            "pageLength": 5,
            "lengthMenu": [5, 10, 15],
            "order": [
                [4, "desc"]
            ]
        });
        $('#kasaHareketleri').DataTable({
            "pageLength": 10,
            "lengthMenu": [5, 10, 20, 50],
            "order": [
                [0, "desc"]
            ]
        });
    });
</script>

<?php require_once ROOT . 'layout/footer.php'; ?>