<?php
if ($_SERVER['SERVER_NAME'] == "localhost") {
    $db = new db('localhost', 'mervan', 'root', '');
} else {
    $db = new db('localhost', 'mervan', 'root', '');
}
class db extends PDO
{
    private static $pk = 'id';
    private static $query;
    private static $pdo;
    public function __construct($host, $name, $user, $pass)
    {
        try {
            self::$pdo = new PDO(
                'mysql:host=' .
                    $host .
                    ';dbname=' .
                    $name,
                $user,
                $pass,
                array(
                    PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8',
                    PDO::MYSQL_ATTR_INIT_COMMAND => 'SET CHARACTER SET utf8',
                    PDO::ATTR_EMULATE_PREPARES => false
                )
            );
        } catch (PDOException $e) {
            exit($e->getMessage());
        }
    }

    public static function getOne($table, $conditions = null, $parameters = array())
    {
        self::$query = self::$pdo->prepare('SELECT * FROM ' . $table . ' ' . $conditions);
        self::$query->execute($parameters);
        return self::$query->fetch(PDO::FETCH_OBJ);
    }
    public static function getId($table, $id)
    {
        self::$query = self::$pdo->prepare('SELECT * FROM ' . $table . ' WHERE ' . self::$pk . '=?');
        self::$query->execute(array($id));
        return self::$query->fetch(PDO::FETCH_OBJ);
    }
    public static function execOne($query, $parameters = array())
    {
        self::$query = self::$pdo->prepare($query);
        self::$query->execute($parameters);
        return self::$query->fetch(PDO::FETCH_OBJ);
    }

    public static function getAll($table, $conditions = null, $parameters = array())
    {
        self::$query = self::$pdo->prepare('SELECT * FROM ' . $table . ' ' . $conditions);
        self::$query->execute($parameters);
        return self::$query->fetchAll(PDO::FETCH_OBJ);
    }

    public static function execAll($query, $parameters = array())
    {
        self::$query = self::$pdo->prepare($query);
        self::$query->execute($parameters);
        return self::$query->fetchAll(PDO::FETCH_OBJ);
    }

    public static function insert($table, $data)
    {
        $values = array();
        $columns = array();
        foreach ($data as $column => $value) {
            $values[] = $value;
            $columns[] = $column;
        }

        $columns = implode(',', $columns);
        $marks = trim(substr(str_repeat('?,', count($values)), 0, -1));

        self::$query = self::$pdo->prepare('INSERT INTO ' . $table . ' (' . $columns . ') VALUES (' . $marks . ')');
        if (self::$query->execute($values)) {
            return self::$pdo->lastInsertId();
        }
        return false;
    }

    public static function update($table, $id, $data, $conditions = null, $parameters = array())
    {
        if ($id) {
            $values = array();
            $columns = array();
            foreach ($data as $column => $value) {
                $values[] = $value;
                $columns[] = $column;
            }

            $columnsAndMarks = implode('=?,', $columns) . '=?';

            $count = self::count($table, 'WHERE ' . self::$pk . '=?', array($id));
            if ($count) {
                self::$query = self::$pdo->prepare('UPDATE ' . $table . ' SET ' . $columnsAndMarks . ' WHERE ' . self::$pk . '=' . $id);
                if (self::$query->execute($values)) {
                    return $id;
                }
                return false;
            }
            return false;
        } else {
            $values = array();
            $columns = array();
            foreach ($data as $column => $value) {
                $values[] = $value;
                $columns[] = $column;
            }

            $columnsAndMarks = implode('=?,', $columns) . '=?';

            $count = self::count($table, $conditions, $parameters);
            if ($count) {
                self::$query = self::$pdo->prepare('UPDATE ' . $table . ' SET ' . $columnsAndMarks . ' ' . $conditions);
                if (self::$query->execute(array_merge($values, $parameters))) {
                    return $id;
                }
                return false;
            }
            return false;
        }
    }

    public static function delete($table, $id, $conditions = null, $parameters = array())
    {
        if ($id) {
            $count = self::count($table, 'WHERE ' . self::$pk . '=?', array($id));
            if ($count) {
                self::$query = self::$pdo->prepare('DELETE FROM ' . $table . ' WHERE ' . self::$pk . '=' . $id);
                if (self::$query->execute()) {
                    return $id;
                }
                return false;
            }
            return false;
        } else {
            $count = self::count($table, $conditions, $parameters);
            if ($count) {
                self::$query = self::$pdo->prepare('DELETE FROM ' . $table . ' ' . $conditions);
                self::$query->execute($parameters);
                return true;
            }
            return false;
        }
    }

    public static function count($table, $conditions = null, $parameters = array())
    {
        self::$query = self::$pdo->prepare('SELECT * FROM ' . $table . ' ' . $conditions);
        self::$query->execute($parameters);
        return self::$query->rowCount();
    }

    public static function execCount($query, $parameters = array())
    {
        self::$query = self::$pdo->prepare($query);
        self::$query->execute($parameters);
        return self::$query->rowCount();
    }

    public function setPrimaryKey($pk)
    {
        self::$pk = $pk;
    }
}
